# Cuadro IV.3
# Intervalo de confianza de la varianza y desviacin tipica

########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro IV.3.V.csv",encoding="latin1")

# Seleccin de las variables de inters
varInteres<-c("Tiempo")
 
# Seleccin de categorizacin de las variables
# Si no se utilizan variables de agrupacin obligatoriamente
# se exige que se coloce varAgrupacin como NULL
# varAgrupacion<-NULL
varAgrupacion<-c("Sexo")


# Indique el nivel de significancia
alfa<-0.05

# Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro IV.3.V.csv"

# Intervalo de confianza para varianza o desviacion tipica?
# tipoInterv<-"var"
tipoInterv<-"desv.est"


########################################################
# Seccin que realiza el procedimiento
########################################################

ic.var.ds<-function(x,alfa=0.05,tipo="desv.est",sup=TRUE){
  x<-x[!is.na(x)]
  if (length(x)>=2){
      n<-length(x)
      var1<-var(x)
      v<-ifelse(sup,(n-1)*var1/(qchisq(alfa/2,n-1)),(n-1)*var1/(qchisq(1-alfa/2,n-1)))
      v<-ifelse(toupper(tipo)=="DESV.EST",sqrt(v),v)
      return(v)
  }else return(NA)
 }

valores<-unlist(datos[,varInteres])
variables<-factor(rep(varInteres,each=dim(datos)[1]))
agrupaciones<-data.frame(datos[rep(1:dim(datos)[1],length(varInteres)),varAgrupacion])
names(agrupaciones)<-varAgrupacion

datos2<-data.frame(agrupaciones,variable=variables,valor=valores)

varAgrupacion<-c(varAgrupacion,"variable")
agrupa<-data.frame(datos2[,varAgrupacion])
if(length(varAgrupacion)==1) names(agrupa)<-varAgrupacion

if(toupper(tipoInterv)=="DESV.EST") var1<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),sd,na.rm=TRUE),responseName="DesviacionEstandar") else
   var1<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),var,na.rm=TRUE),responseName="Varianza") 
   
ICs1<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),ic.var.ds,alfa=alfa,tipo=tipoInterv),responseName="LimSup")
ICs2<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),ic.var.ds,sup=FALSE,alfa=alfa,tipo=tipoInterv),responseName="LimInf")

if(toupper(tipoInterv)=="DESV.EST") ICs<-na.omit(data.frame(ICs2,DesviacionEstandar=var1[,"DesviacionEstandar"],LimSup=ICs1[,"LimSup"])) else
   ICs<-na.omit(data.frame(ICs2,Varianza=var1[,"Varianza"],LimSup=ICs1[,"LimSup"]))

########################################################
# Seccin que muestra los resultados
########################################################

ICs

if (!is.null(ArchivodeSalida)) write.csv2(ICs,ArchivodeSalida,row.names=FALSE)





